﻿//////////////////////////////////////////////
// AtmosphereLutProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Program ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "AtmosphereEffectInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct AtmosphereLutProgramIdGenerator
	{
		static unsigned long long generate (const AtmosphereEffectInfo& info) ;
	} ;

	struct AtmosphereLutProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_ATMOSPHERE_LUT_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class AtmosphereLutProgramTracker final : public ProgramTracker<AtmosphereEffectInfo, AtmosphereLutProgramIdGenerator, AtmosphereLutProgramNameGenerator>
	{
		public :

			// Functions
			// Constructor, destructor
			AtmosphereLutProgramTracker (nkGraphics::System* graphicsSystem) noexcept ;
			virtual ~AtmosphereLutProgramTracker () ;
	} ;
}